/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.ClientHandler;
import com.talpie.linker.ClientListeners;
import com.talpie.linker.ServerListeners;
import com.talpie.linker.StreamFrame;
import com.talpie.linker.StreamSocketClient;
import com.talpie.linker.StreamSocketServer;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class StreamStatsListener
implements ServerListeners.StreamSocket,
ServerListeners.StreamMessage,
ServerListeners.StreamProgress,
ClientListeners.StreamSocket,
ClientListeners.StreamMessage,
ClientListeners.StreamProgress {
    private final ConcurrentHashMap<String, Cnt> byStream = new ConcurrentHashMap();

    private Cnt cnt(String id) {
        return this.byStream.computeIfAbsent(id, k -> new Cnt());
    }

    @Override
    public void streamFrameIn(Object c, Timestamp ts, ClientHandler ch, StreamSocketServer ss, StreamFrame f, long bytes) {
        Cnt x = this.cnt(f.streamId);
        x.rxFrames.incrementAndGet();
        x.rxBytes.addAndGet(bytes);
    }

    @Override
    public void streamFrameOut(Object c, Timestamp ts, ClientHandler ch, StreamSocketServer ss, StreamFrame f, long bytes) {
        Cnt x = this.cnt(f.streamId);
        x.txFrames.incrementAndGet();
        x.txBytes.addAndGet(bytes);
    }

    @Override
    public void streamProgressRx(Object c, Timestamp ts, ClientHandler ch, StreamSocketServer ss, long frames, long bytes) {
    }

    @Override
    public void streamProgressTx(Object c, Timestamp ts, ClientHandler ch, StreamSocketServer ss, long frames, long bytes) {
    }

    @Override
    public void streamFrame(Object c, Timestamp ts, StreamSocketClient sc, StreamFrame f) {
        Cnt x = this.cnt(f.streamId);
        x.rxFrames.incrementAndGet();
    }

    @Override
    public void streamProgressRx(Object c, Timestamp ts, StreamSocketClient sc, long frames, long bytes) {
        Cnt x = this.cnt(sc.getStreamId());
        x.rxBytes.set(bytes);
        x.rxFrames.set(frames);
    }

    @Override
    public void streamProgressTx(Object c, Timestamp ts, StreamSocketClient sc, long frames, long bytes) {
        Cnt x = this.cnt(sc.getStreamId());
        x.txBytes.set(bytes);
        x.txFrames.set(frames);
    }

    public long getRxFrames(String id) {
        return this.cnt((String)id).rxFrames.get();
    }

    public long getRxBytes(String id) {
        return this.cnt((String)id).rxBytes.get();
    }

    public long getTxFrames(String id) {
        return this.cnt((String)id).txFrames.get();
    }

    public long getTxBytes(String id) {
        return this.cnt((String)id).txBytes.get();
    }

    private static final class Cnt {
        final AtomicLong rxFrames = new AtomicLong();
        final AtomicLong rxBytes = new AtomicLong();
        final AtomicLong txFrames = new AtomicLong();
        final AtomicLong txBytes = new AtomicLong();

        private Cnt() {
        }
    }
}

