/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public final class SpeakerPlayer
implements AutoCloseable {
    private final BlockingQueue<byte[]> in;
    private final SourceDataLine spk;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread thread;
    private final AudioFormat inFmt;
    private AudioFormat playFmt;
    private boolean upmixToStereo = false;
    private int frameBytes;

    public SpeakerPlayer(BlockingQueue<byte[]> in, Mixer.Info outputDevice, AudioFormat inFmt) throws LineUnavailableException {
        this.in = in;
        this.inFmt = inFmt;
        AudioFormat[] candidates = new AudioFormat[]{inFmt, new AudioFormat(inFmt.getSampleRate(), 16, 2, true, false), new AudioFormat(44100.0f, 16, inFmt.getChannels(), true, false), new AudioFormat(44100.0f, 16, 2, true, false)};
        SourceDataLine line = null;
        AudioFormat chosen = null;
        LineUnavailableException last = null;
        Mixer mx = AudioSystem.getMixer(outputDevice);
        for (AudioFormat cand : candidates) {
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, cand);
                if (!mx.isLineSupported(info)) continue;
                line = (SourceDataLine)mx.getLine(info);
                int openBuf = Math.max((int)(cand.getSampleRate() * 0.025f) * cand.getFrameSize() * 4, 8192);
                line.open(cand, openBuf);
                chosen = cand;
                break;
            }
            catch (LineUnavailableException e) {
                last = e;
            }
        }
        if (line == null || chosen == null) {
            throw last != null ? last : new LineUnavailableException("No supported playback format");
        }
        this.spk = line;
        this.playFmt = chosen;
        this.upmixToStereo = inFmt.getChannels() == 1 && chosen.getChannels() == 2;
        this.frameBytes = (int)(inFmt.getSampleRate() * 0.05f) * inFmt.getFrameSize();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.spk.start();
            this.thread = new Thread(this::runPlayback, "SpeakerPlayer");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private void runPlayback() {
        byte[] silence = new byte[(int)(this.playFmt.getSampleRate() * 0.05f) * this.playFmt.getFrameSize()];
        while (this.running.get()) {
            try {
                byte[] frame = this.in.poll(5L, TimeUnit.MILLISECONDS);
                if (frame == null) {
                    this.spk.write(silence, 0, silence.length);
                    continue;
                }
                if (this.upmixToStereo) {
                    int samples = frame.length / 2;
                    byte[] stereo = new byte[samples * 4];
                    int i = 0;
                    int j = 0;
                    while (i < frame.length) {
                        byte lo = frame[i];
                        byte hi = frame[i + 1];
                        stereo[j] = lo;
                        stereo[j + 1] = hi;
                        stereo[j + 2] = lo;
                        stereo[j + 3] = hi;
                        i += 2;
                        j += 4;
                    }
                    this.spk.write(stereo, 0, stereo.length);
                    continue;
                }
                this.spk.write(frame, 0, frame.length);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        this.running.set(false);
        try {
            this.spk.drain();
            this.spk.stop();
            this.spk.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

